package com.richard_gauthier.Text 
{
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	
	/**
	 * ...
	 * @author Richard GAUTHIER
	 * Professeur d'ISN
	 * Lycée Paul Sérusier
	 * 29270 Carhaix
	 * contact@sciencesappliquees.com
	 */
	public class ZoneText extends Sprite 
	{
		private var leTexte:TextField = new TextField();
		private var formatTexte:TextFormat = new TextFormat();
			
		private var taillePolice:int;
		
		private var largeur : Number;
		
		public function ZoneText(taillePolice:int = 20, largeur:int = 200) 
		{
			this.taillePolice = taillePolice;
			//formatTexte.bold = true;
			//formatTexte.color = 0xFF0000;
			//formatTexte.align = TextFormatAlign.LEFT;
			formatTexte.size = taillePolice;
			
			this.largeur = largeur;
			
			leTexte.width = largeur;
			leTexte.height = taillePolice;
			//leTexte.backgroundColor = 0xff0000;
			leTexte.autoSize = TextFieldAutoSize.CENTER;
			leTexte.selectable = false;
			leTexte.wordWrap = true;
			leTexte.defaultTextFormat = formatTexte;
			leTexte.htmlText = " ";
			addChild(leTexte);
			
		}
		
		public function setText(monTexte:String):void
		{  
			leTexte.defaultTextFormat = formatTexte;
			leTexte.htmlText = "<p>"+monTexte+"</p>";
		
		}
		
		public function clear():void
		{  
			leTexte.text = "";
		}
		
		
		public function addText(monTexte:String):void
		{  
			leTexte.appendText(monTexte +"\n");
			
			
		
		}
		
		
		public function getText():String
		{  
			return leTexte.text;
		
		}
		
		public function setBorder(valeur:Boolean):void
		{  
			leTexte.border = valeur;
			
		
		}
		
		
		
		public function setBackgroundColor(couleur:uint):void
		{  
			
			this.graphics.clear();
			this.graphics.beginFill(couleur,0.6);
			this.graphics.drawRect(0, 0, largeur, this.height);
		
		}
		
		public function setBold(booleen : Boolean):void
		{  
			formatTexte.bold = booleen;
			
			
		}
		
		public function setItalic(booleen : Boolean):void
		{  
			formatTexte.italic = booleen;
			
			
		}
		
		public function setUnderline(booleen : Boolean):void
		{  
			formatTexte.underline = booleen;
			
			
		}
		
				
		public function color(myColor:uint):void
		{  
			formatTexte.color = myColor;
			
		}
		
		public function align(monTexte:String):void
		{   switch (monTexte)
			{
				case "center": 
					formatTexte.align = TextFormatAlign.CENTER;
					break;
				case "right": 
					formatTexte.align = TextFormatAlign.RIGHT;
					break;
				default: 
					formatTexte.align = TextFormatAlign.LEFT;
			
			}
			
		
		}
	}

}